<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:p="http://www.sec.gov/edgar/ta/tatwofiler">

	<xsl:template name="item4_signature">
		<h1>
			<xsl:value-of select="$submissionType"/>: Signature
		</h1>
		<div class="information">
			<p>
				SIGNATURE: The Registrant submitting this Form, and the person signing the Form, hereby represent that all the information contained in the
				Form is true, correct, and complete.
			</p>
		</div>

		<table role="presentation">
			<tr>
				<td class="label">
					<b>12(a).</b> Signature of Official responsible for Form:
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:formData/p:signatureData/p:signatureName" />
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<b>12(b).</b> Telephone Number:
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:formData/p:signatureData/p:signaturePhoneNumber" />
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<b>12(c).</b> Title of Signing Officer:
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:formData/p:signatureData/p:signatureTitle" />
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<b>12(d).</b> Date Signed (Month/Day/Year):
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:formData/p:signatureData/p:signatureDate" />
					</div>
				</td>
			</tr>
		</table>
	</xsl:template>
</xsl:stylesheet>